### 35.3. 测试Spring Boot应用

一个Spring Boot应用只是一个Spring ApplicationContext，所以在测试它时除了正常情况下处理一个vanilla Spring　context外不需要做其他特别事情。唯一需要注意的是，如果你使用SpringApplication创建上下文，外部配置，日志和Spring Boot的其他特性只会在默认的上下文中起作用。

Spring Boot提供一个@SpringApplicationConfiguration注解用来替换标准的spring-test　@ContextConfiguration注解。如果使用@SpringApplicationConfiguration来设置你的测试中使用的ApplicationContext，它最终将通过SpringApplication创建，并且你将获取到Spring Boot的其他特性。

示例如下：
```java
@RunWith(SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes = SampleDataJpaApplication.class)
public class CityRepositoryIntegrationTests {
@Autowired
CityRepository repository;
// ...
}	
```
**提示**：上下文加载器会通过查找@WebIntegrationTest或@WebAppConfiguration注解来猜测你想测试的是否是web应用（例如，是否使用MockMVC，MockMVC和@WebAppConfiguration是spring-test的一部分）。

如果想让一个web应用启动，并监听它的正常的端口，你可以使用HTTP来测试它（比如，使用RestTemplate），并使用@WebIntegrationTest注解你的测试类（或它的一个父类）。这很有用，因为它意味着你可以对你的应用进行全栈测试，但在一次HTTP交互后，你需要在你的测试类中注入相应的组件并使用它们断言应用的内部状态。

示例：
```java
@RunWith(SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes = SampleDataJpaApplication.class)
@WebIntegrationTest
public class CityRepositoryIntegrationTests {
@Autowired
CityRepository repository;
RestTemplate restTemplate = new TestRestTemplate();
// ... interact with the running server
}
```
**注**：Spring测试框架在每次测试时会缓存应用上下文。因此，只要你的测试共享相同的配置，不管你实际运行多少测试，开启和停止服务器只会发生一次。

你可以为@WebIntegrationTest添加环境变量属性来改变应用服务器端口号，比如@WebIntegrationTest("server.port:9000")。此外，你可以将server.port和management.port属性设置为０来让你的集成测试使用随机的端口号，例如：
```java
@RunWith(SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes = MyApplication.class)
@WebIntegrationTest({"server.port=0", "management.port=0"})
public class SomeIntegrationTests {
// ...
}
```
可以查看[Section 64.4, “Discover the HTTP port at runtime”](../IX. ‘How-to’ guides/64.4. Discover the HTTP port at runtime.md)，它描述了如何在测试期间发现分配的实际端口。
